package com.instabug.library.sessionV3.ratingDialogDetection

import android.app.Activity
import android.os.Build
import androidx.annotation.RequiresApi
import androidx.annotation.VisibleForTesting
import java.lang.ref.WeakReference



interface KeyboardDurationDetector {
    @RequiresApi(Build.VERSION_CODES.R)
    fun register(activity: Activity)
    @RequiresApi(Build.VERSION_CODES.R)
    fun unregister()
    @RequiresApi(Build.VERSION_CODES.R)
    fun getDuration(): Long?
}

class KeyboardDurationDetectorImpl(
    private val keyboardEventListenerProvider: KeyboardEventListenerProvider
) : KeyboardDurationDetector,
    AppRatingDialogKeyboardEventListener.KeyboardCallback {

    private var keyboardListener: WeakReference<AppRatingDialogKeyboardEventListener>? = null

    @VisibleForTesting
    var keyboardStartTimeMicros: Long? = null

    private var totalDuration: Long = 0

    override fun register(activity: Activity) {
        if (keyboardListener?.get() == null)
            keyboardListener = WeakReference(keyboardEventListenerProvider(activity, this))
    }

    @RequiresApi(Build.VERSION_CODES.R)
    override fun unregister() {
        keyboardListener?.get()?.unregisterKeyboardListener()
        keyboardListener = null
        keyboardStartTimeMicros = null
        totalDuration = 0
    }

    override fun getDuration(): Long? = totalDuration.takeIf { it > 0 }
    override fun isOpen(isKeyboardOpen: Boolean, timeMicros: Long) {
        if (isKeyboardOpen) keyboardStartTimeMicros = timeMicros
        else putNewDuration(timeMicros)
    }

    private fun putNewDuration(closedTimeStamp: Long) = keyboardStartTimeMicros
        ?.takeIf { it > 0 }
        ?.let {
            val latestDuration = closedTimeStamp - it
            totalDuration += latestDuration
            keyboardStartTimeMicros = null
        }

}