package com.instabug.library.session

import android.content.Context
import com.instabug.library.IBGNetworkWorker
import com.instabug.library.internal.utils.PreferencesUtils
import com.instabug.library.settings.SettingsManager
import com.instabug.library.util.threading.PoolProvider

object SessionsServiceLocator {

    @JvmStatic
    fun getSessionsLocalDataSource() = SessionsLocalDataSource()

    @JvmStatic
    fun getPreferencesUtils(context: Context) =
        PreferencesUtils(context, SettingsManager.INSTABUG_SHARED_PREF_NAME)

    @JvmStatic
    fun postNetworkTask(runnable: Runnable): Void? {
        PoolProvider.getNetworkingSingleThreadExecutor(IBGNetworkWorker.CORE).execute(runnable)
        return null
    }

    @JvmStatic
    fun getSessionsConfigurations(): SessionsConfigurationsManager {
        return SessionsConfigurationsManagerImpl
    }
}