package com.instabug.library.networkv2

/**
 *@author mhashim6 on 13/6/22
 */
object BodyBufferHelper {
	private const val MAX_SIZE = 1024L * 1024L
	private const val MULTIPART_REQUEST_PREFIX = "multipart"
	const val MAX_SIZE_ALERT = "Body omitted due to its large size > 1MB"
	const val MULTIPART_ALERT = "multipart body was omitted"

	@JvmStatic
	@JvmOverloads
	fun isBodySizeAllowed(size: Long, maxSize: Long = MAX_SIZE) = size <= maxSize

	@JvmStatic
	@JvmOverloads
	fun isBodySizeAllowed(body: String, maxSize: Long = MAX_SIZE) = body.encodeToByteArray().size <= maxSize

	@JvmStatic
	fun isMultipartType(contentType: String?) = contentType != null && contentType.startsWith(MULTIPART_REQUEST_PREFIX)

	@JvmStatic
	fun StringBuffer.clear() {
		setLength(0)
	}

	@JvmStatic
	inline fun generateBodyMsg(isBufferDisabled: Boolean, size: Long, fallback: () -> String): String = when {
		isBufferDisabled -> MULTIPART_ALERT
		isBodySizeAllowed(size).not() -> MAX_SIZE_ALERT
		else -> fallback()
	}
}