package com.instabug.library.networkDiagnostics.model

import androidx.annotation.VisibleForTesting
import com.instabug.library.util.DateUtils
import org.json.JSONException
import org.json.JSONObject
import java.util.Date

@VisibleForTesting
const val KEY_DATE = "date"
@VisibleForTesting
const val KEY_SUCCESS_COUNT = "success_count"
@VisibleForTesting
const val KEY_FAIL_COUNT = "fail_count"

data class NetworkDiagnostics(
    val date: Date = DateUtils.getTodayDateWithoutTime(),
    val successCount: Int = 0,
    val failCount: Int = 0
)

fun NetworkDiagnostics.toJson(): String {
    val json = JSONObject()
    json.put(KEY_DATE, date.time)
    json.put(KEY_SUCCESS_COUNT, successCount)
    json.put(KEY_FAIL_COUNT, failCount)

    return json.toString()
}

fun String.toNetworkDiagnostics(): NetworkDiagnostics {
    return try {
        val json = JSONObject(this)
        NetworkDiagnostics(
            date = Date(json.getLong(KEY_DATE)),
            successCount = json.getInt(
                KEY_SUCCESS_COUNT
            ), failCount = json.getInt(KEY_FAIL_COUNT)
        )

    } catch (exception: JSONException) {
        NetworkDiagnostics()
    }
}


fun NetworkDiagnostics.getTotalRequestsCount(): Int = successCount + failCount


