package com.instabug.library.model.v3Session

object Constants {
    const val DEBUG_PROPERTY = "debug.instabug.apm.app"
}

object SessionsExperimentsKeys {
    const val SESSION_EXPERIMENTS_KEY = "exp"
    const val EXPERIMENTS_ARRAY_KEY = "expl"
    const val EXPERIMENTS_DROPPED_COUNT_KEY = "dxsl"
}

object SessionsFeaturesFlagsKeys {
    const val SESSION_FEATURES_FLAGS_KEY = "ff"
}

object SessionsRequestKeys {
    const val SESSIONS_KEY = "ses"
    const val DROPPED_SESSIONS_COUNT_KEY = "dsc"
}


object IBGSessionKeys {
    const val ID_KEY = "id"
    const val SESSION_V2_SENT_KEY = "s2s"
    const val DURATION_KEY = "d"
    const val IS_STITCHED_SESSION_KEY = "ss"
    const val RANDOM_PARTIAL_SESSION_ID = "pid"
    const val SESSION_REPLAY_ENABLED = "sre"
}

object AppDataKeys {
    const val OS_KEY = "os"
    const val DEBUG_MODE_KEY = "dm"
    const val DEVICE_KEY = "de"
    const val APP_VERSION_KEY = "av"
    const val SDK_VERSION_KEY = "sv"
    const val APP_TOKEN_KEY = "at"
    const val LOCALE_KEY = "lc"
    const val DENSITY_KEY = "dst"
    const val SCREEN_SIZE_KEY = "sz"
    const val BUNDLE_ID_KEY = "bid"
}

object UserDataKeys {
    const val UUID_KEY = "uu"
    const val USER_NAME_KEY = "un"
    const val USER_EMAIL_KEY = "uem"
    const val USER_EVENTS_KEY = "ue"
    const val CUSTOM_ATTRIBUTES_KEY = "ca"
}

object ProductionUsageKeys {
    const val STORE_URL_KEY = "su"
    const val BUGS_PRODUCTION_USAGE_KEY = "pub"
    const val FEATURES_REQUESTS_PRODUCTION_USAGE_KEY = "pufr"
    const val SURVEYS_PRODUCTION_USAGE_KEY = "pus"
    const val APM_PRODUCTION_USAGE_KEY = "pua"
    const val CRASHES_PRODUCTION_USAGE_KEY = "puc"
}

object StartTimeKeys {
    const val BACKGROUND_START_TIME_KEY = "bs"
    const val FOREGROUND_START_TIME_KEY = "fs"
}

object PreferencesKeys {
    const val DROPPED_SESSIONS_COUNT_KEY = "v3_dropped_sessions_count"
    const val SESSIONS_SYNC_INTERVAL_KEY = "v3_sync_interval"
    const val SESSIONS_LAST_SYNC_TIME_KEY = "v3_last_sync_time"
    const val EXPERIMENTS_ENABLED_KEY = "v3_experiments_enabled"
    const val EXPERIMENTS_STORE_LIMIT_KEY = "v3_experiments_store_limit"
    const val DEBUG_MODE_ENABLED_KEY = "v3_debug_mode_enabled"
    const val SESSIONS_STORE_LIMIT_KEY = "v3_sessions_store_limit"
    const val SESSIONS_REQUEST_LIMIT_KEY = "v3_sessions_request_limit"
    const val LAST_FOREGROUND_TIME_KEY = "v3_last_foreground_time"
    const val STITCHING_ENABLED_KEY = "v3_stitching_enabled"
    const val STITCHING_SESSION_TIMEOUT_KEY = "v3_stitching_session_timeout"
    const val NON_FATAL_STORE_LIMIT_KEY = "v3_non_fatal_store_limit"
    const val ANR_STORE_LIMIT_KEY = "v3_anr_store_limit"
    const val FATAL_HANG_STORE_LIMIT_KEY = "v3_fatal-hang_store_limit"
    const val DURATION_PREF_NAME = "ibg_session_duration"
    const val PERIODIC_DURATION_CAPTURE_ENABLED = "v3_periodic_duration_capture_enabled"
    const val PERIODIC_DURATION_CAPTURE_INTERVAL = "v3_periodic_duration_capture_interval"
    const val CUSTOM_STORE_RATE_API_ENABLED = "custom_store_rate_api_enabled"
    const val ALLOWED_INTERVAL_BEFORE_REDIRECTION = "allowed_interval_before_redirection"
}

object Defaults {
    const val DEFAULT_SESSIONS_DROPPED_COUNT = 0
    const val DEFAULT_SESSIONS_STORE_LIMIT = 100
    const val DEFAULT_STORE_URL = "other"
    const val DEFAULT_STITCHING_ENABLED = true
    const val DEFAULT_STITCHING_SESSION_TIMEOUT = 1800
    const val DEFAULT_LAST_FOREGROUND_TIME = -1L
    const val DEFAULT_SYNC_INTERVAL = 360L
    const val DEFAULT_LAST_SYNC = -1L
    const val DEFAULT_SESSIONS_REQUEST_LIMIT = 10
    const val DEFAULT_V3_ENABLED = true
    const val DEFAULT_DEBUG_MODE_ENABLED = false
    const val DEFAULT_V3_PERCENTAGE = 0.0
    const val DEFAULT_EXPERIMENTS_ENABLED = false
    const val DEFAULT_EXPERIMENTS_STORE_LIMIT = 100
    const val DEFAULT_NON_FATAL_STORE_LIMIT = 100
    const val DEFAULT_ANR_STORE_LIMIT = 100
    const val DEFAULT_FATAL_HANG_STORE_LIMIT = 100
    const val DEFAULT_PERIODIC_DURATION_CAPTURE_INTERVAL = 2_000L
    const val DEFAULT_PERIODIC_DURATION_CAPTURE_ENABLED = true
    const val DEFAULT_CUSTOM_STORE_RATE_API = false

    /*default interval before redirection to play store in seconds */

    const val DEFAULT_ALLOWED_INTERVAL_BEFORE_REDIRECTION = 10000L

}

object SessionsFeaturesFlags {

    const val FLAG_V3_SESSIONS = "v3"
    const val FLAG_V3_ENABLED = "e"
    const val FLAG_DEBUG_MODE_ENABLED = "dme"
    const val FLAG_SYNC_INTERVAL = "i"
    const val FLAG_SESSIONS_REQUEST_LIMIT = "rl"
    const val FLAG_SESSIONS_STORE_LIMIT = "sl"
    const val FLAG_STITCHING_ENABLED = "se"
    const val FLAG_STITCHING_SESSION_TIMEOUT = "st"
    const val FLAG_EXPERIMENTS = "ex"
    const val FLAG_EXPERIMENTS_ENABLED = "en"
    const val FLAG_EXPERIMENTS_STORE_LIMIT = "l"
    const val FLAG_NON_FATAL_STORE_LIMIT = "nf"
    const val FLAG_ANR_STORE_LIMIT = "anrc"
    const val FLAG_FATAL_HANG_STORE_LIMIT = "fh"
    const val FLAG_PERIODIC_DURATION_CAPTURE_ENABLED = "an_capture_session_duration_periodically"
    const val FLAG_PERIODIC_DURATION_CAPTURE_INTERVAL = "an_capture_session_duration_interval"
}

object RatingDialogDetection {
    // feature keys
    const val REVIEW_PROMPT_KEY = "rp"
    const val REVIEW_PROMPT_END_TIME_KEY = "etmus"
    const val REVIEW_PROMPT_DURATION_KEY = "dmus"
    const val REVIEW_KEYBOARD_DURATION_KEY = "kdmus"
    const val CUSTOM_STORE_RATING_MODE_KEY = "csr"
    const val CUSTOM_STORE_RATE_API_ENABLED_KEY = "custom_store_rating_api"
    const val CUSTOM_STORE_RATE_ALLOWED_INTERVAL_BEFORE_REDIRECTION_KEY =
        "csr_interval_before_redirection"

    // google store keys
    const val PLAY_STORE_ACTIVITY = "PlayCoreDialogWrapperActivity"
    const val PLAY_STORE_PACKAGE_NAME = "com.android.vending"

    // error messages
    const val RATING_DIALOG_CACHING_ERROR_MESSAGE =
        "Something went wrong while putting rating dialog detection info "
    const val RATING_DIALOG_QUERY_ERROR_MESSAGE =
        "Something Went Wrong while query sessions rating Data"
    const val RATE_DETECTION_FILTER_ERROR_MESSAGE =
        "Something went wrong while filtering sessions with rate detection data"
    const val RATING_DIALOG_DETECTOR_INIT_ERROR = "Error while initializing RatingDialogDetection "
    const val RATING_DIALOG_DETECTOR_END_ERROR = "Error while ending RatingDialogDetection "
    const val SR_DISABLE_SESSIONS_FAILED = "Error while disabling SR for cached sessions"
    const val SOMETHING_WENT_WRONG_WHILE_QUERY_SR_EVALUATED =
        "Something went wrong while query sessions by sr_evaluated value"


}