package com.instabug.library.model.session.config;

import androidx.annotation.StringDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import static com.instabug.library.model.session.config.SessionsConfigParameter.MAX_SESSIONS_PER_REQUEST;
import static com.instabug.library.model.session.config.SessionsConfigParameter.SYNC_INTERVAL;
import static com.instabug.library.model.session.config.SessionsConfigParameter.SYNC_MODE;

@Retention(RetentionPolicy.SOURCE)
@StringDef({SYNC_INTERVAL, MAX_SESSIONS_PER_REQUEST, SYNC_MODE})
public @interface SessionsConfigParameter {

    String SYNC_INTERVAL = "interval";
    String MAX_SESSIONS_PER_REQUEST = "max_number";
    String SYNC_MODE = "mode";
}
