package com.instabug.library.model;

import android.graphics.Bitmap;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class ScreenshotResponse {

    @NonNull
    @ScreenshotCaptureStatus
    private final int status;

    @Nullable
    private Bitmap screenshotBitmap;
    @Nullable
    private Throwable throwable;

    public ScreenshotResponse(@NonNull @ScreenshotCaptureStatus int status, @Nullable Bitmap screenshotBitmap) {
        this.status = status;
        this.screenshotBitmap = screenshotBitmap;
    }

    public ScreenshotResponse(@NonNull @ScreenshotCaptureStatus int status, @Nullable Throwable throwable) {
        this.status = status;
        this.throwable = throwable;
    }

    @NonNull
    @ScreenshotCaptureStatus
    public int getStatus() {
        return status;
    }

    @Nullable
    public Bitmap getScreenshotBitmap() {
        return screenshotBitmap;
    }

    @Nullable
    public Throwable getThrowable() {
        return throwable;
    }
}
