package com.instabug.library.internal.video

import android.app.ActivityManager
import android.content.Context


object ServiceUtils {
    /**
     * A method to detect if a specific service running foreground.
     * This was used basically in ScreenRecoding on Android 10
     *
     * @param context
     * @param serviceClass
     * @return
     */
    @JvmStatic
    fun isServiceRunningInForeground(context: Context, serviceClass: Class<*>): Boolean {
        return context
            .runningServices()
            ?.any { it.service.className == serviceClass.name && it.foreground } ?: false
    }

    /**
     * A method to detect if their is a foreground service that currenlty running or not
     *
     * @param context
     * @return
     */
    @JvmStatic
    fun hasForegroundServiceRunning(context: Context): Boolean {
        return context.runningServices()?.any { it.foreground } ?: false
    }

    @JvmStatic
    @Suppress("DEPRECATION")
    private fun Context.runningServices(): List<ActivityManager.RunningServiceInfo>? {
        val manager = getSystemService(Context.ACTIVITY_SERVICE) as? ActivityManager
        return manager?.getRunningServices(Int.MAX_VALUE)
    }
}