package com.instabug.library.internal.utils;

import android.util.Log;

import static com.instabug.library.InstabugCustomTextPlaceHolder.Key;

public enum PlaceHolderDeprecationLogger {


    CUSTOM_SURVEY_THANK_YOU {
        @Override
        String getMessage(Key primaryKey, Key... secondaryKeys) {
            return "Warning: This key " +
                    primaryKey.name() +
                    (secondaryKeys.length > 0 ? " and " : " ") +
                    flatMap(secondaryKeys) +
                    "will be deprecated with the next release. " +
                    "You will be able to edit this message from the dashboard from this point on.";
        }
    }, CUSTOM_DEPRECATION_MESSAGE {
        @Override
        String getMessage(Key primaryKey, Key... replacement) {
            return "This key " + primaryKey + " has been deprecated, " +
                    "you can use " + flatMap(replacement) + " instead";
        }
    };


    /**
     * Checks whether or not this {@code key} is deprecated.
     * If yes it logs a warning message to the user, nothing otherwise
     */
    public static void logWarningIfDeprecated(Key key) {
        // we do not have deprecated Keys at the moment
    }

    /**
     * Logs a warning message for the passed keys
     *
     * @param primaryKey    The actual deprecated key that the user is using
     * @param secondaryKeys If there is any other related keys that needs to be mentioned
     */
    void logW(Key primaryKey, Key... secondaryKeys) {
        Log.w("INSTABUG", getMessage(primaryKey, secondaryKeys));
    }

    String flatMap(Key... secondaryKeys) {
        StringBuilder messageBuilder = new StringBuilder();
        if (secondaryKeys.length > 0) {
            for (Key secondaryKey : secondaryKeys) {
                messageBuilder.append("<")
                        .append(secondaryKey)
                        .append("> ");
            }
        }
        return messageBuilder.toString();
    }

    abstract String getMessage(Key primaryKey, Key... secondaryKeys);
}
