package com.instabug.library.internal.orchestrator

import com.instabug.library.core.InstabugCore
import com.instabug.library.settings.SettingsManager
import com.instabug.library.user.handlepushtoken.PushNotificationRequestHelper

class LinkPushTokenAction : Action {
    override fun run() {

        InstabugCore.setPushNotificationTokenSent(false)

        val pushToken = SettingsManager.getPushNotificationToken()
        if (pushToken.isNullOrBlank()) return
        PushNotificationRequestHelper()
            .handleSendPushTokenRequests(pushToken) {
                InstabugCore.setPushNotificationTokenSent(true)
            }
    }
}