package com.instabug.library.internal.dataretention;

import com.instabug.library.internal.storage.cache.db.DatabaseManager;
import com.instabug.library.internal.storage.cache.db.SQLiteDatabaseWrapper;
import com.instabug.library.util.threading.PoolProvider;

import java.util.Arrays;
import java.util.List;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;

/**
 * @deprecated see {@link com.instabug.library.internal.dataretention.core.DataInspector}
 */
@Deprecated
public class DisposableData {

    private final List<DisposalPolicy> disposalPolicies;

    public DisposableData(@NonNull List<DisposalPolicy> disposalPolicies) {
        this.disposalPolicies = disposalPolicies;
    }

    public DisposableData(@NonNull DisposalPolicy... disposalPolicies) {
        this.disposalPolicies = Arrays.asList(disposalPolicies);
    }

    public List<DisposalPolicy> getDisposalPolicies() {
        return disposalPolicies;
    }

    public void disposeAsync() {
        PoolProvider.postIOTask(new Runnable() {
            @Override
            public void run() {
                dispose();
            }
        });
    }

    public void dispose() {
        for (DisposalPolicy disposalPolicy : disposalPolicies) {
            dispose(disposalPolicy);
        }
    }

    @VisibleForTesting
    void dispose(DisposalPolicy disposalPolicy) {
        Scope scope = disposalPolicy.scope();
        dispose(scope, disposalPolicy.retentionContract().maxRetentionPeriodMillis(), disposalPolicy.exceptionRules());
    }

    @VisibleForTesting
    void dispose(Scope scope, long maxRetentionPeriod, List<Rule> exceptionRules) {
        String table = scope.table();
        List<Record> records = scope.records();
        dispose(table, records, maxRetentionPeriod, exceptionRules);
    }

    @VisibleForTesting
    void dispose(String table, List<Record> records, long maxRetentionPeriod, List<Rule> exceptionRules) {
        for (Record record : records) {
            if (shouldDispose(record, maxRetentionPeriod) && !isException(record, exceptionRules)) {
                disposeRecord(table, record);
            }
        }
    }

    @VisibleForTesting
    void disposeRecord(String table, Record record) {
        SQLiteDatabaseWrapper db = DatabaseManager.getInstance().openDatabase();
        String whereClause = record.getIdentifierField().getName() + " = ? AND " +
                record.getLastLoginField().getName() + " = ?";
        String[] whereArgs = new String[]{record.getIdentifierField().getValue(), record.getLastLoginField().getValue().toString()};
        try {
            db.beginTransaction();
            db.delete(table, whereClause, whereArgs);
            db.setTransactionSuccessful();
        } finally {
            db.endTransaction();
            db.close();
        }
    }

    @VisibleForTesting
    boolean shouldDispose(Record record, long maxRetentionPeriod) {
        if (record.getLastLoginField().getValue() == 0) return false;
        long l = System.currentTimeMillis() - record.getLastLoginField().getValue();
        return l > maxRetentionPeriod;
    }

    @VisibleForTesting
    boolean isException(Record record, List<Rule> exceptionRules) {
        for (Rule exceptionRule : exceptionRules) {
            if (exceptionRule.isSatisfiable(record)) {
                return true;
            }
        }
        return false;
    }
}
