package com.instabug.library.instacapture.screenshot.pixelcopy;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.view.View;
import android.view.WindowManager;

import androidx.annotation.NonNull;

import com.instabug.library.Constants;
import com.instabug.library.instacapture.screenshot.FieldHelper;
import com.instabug.library.instacapture.screenshot.RootViewInfo;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;

import java.util.List;
import java.util.concurrent.ExecutionException;

public class DialogUiRenderer {

    /**
     * Render the popup windows on the captured screenshot.
     *
     * @param activity the screenshot is captured from.
     * @param bitmap   to render components on it.
     */
    public static void tryRenderDialogs(Activity activity, @NonNull Bitmap bitmap) {
        if (activity == null) return;

        List<RootViewInfo> rootViews = FieldHelper.getRootViews(activity, null);

        if (rootViews == null || rootViews.isEmpty()) {
            return;
        }

        try {
            Canvas canvas = new Canvas(bitmap);
            for (int index = rootViews.size() - 1; index >= 0; index--) {
                RootViewInfo rootViewInfo = rootViews.get(index);
                if (rootViewInfo.getLayoutParams().type == WindowManager.LayoutParams.TYPE_BASE_APPLICATION) {
                    //This type is usually an activity so no need to draw any window below it.
                    return;
                } else if (rootViewInfo.isOverlayViews()) {
                    drawDialogDimEffect(canvas, rootViewInfo);
                    drawPanel(canvas, rootViewInfo);
                }
            }
        } catch (Exception e) {
            InstabugSDKLogger.e(Constants.LOG_TAG, "Something went wrong while getting root views", e);
        }
    }

    public static void drawDialogDimEffect(@NonNull Canvas canvas, @NonNull RootViewInfo rootViewInfo) {
        float dimAmount = rootViewInfo.getLayoutParams().dimAmount;
        if (dimAmount < 1) {
            int dimColorAlpha = (int) (dimAmount * 255);
            canvas.drawColor(Color.argb(dimColorAlpha, 0, 0, 0));
        }
    }

    private static void drawPanel(@NonNull Canvas canvas, @NonNull RootViewInfo rootViewInfo) throws ExecutionException, InterruptedException {
        View dialogView = rootViewInfo.getView();
        if (dialogView.getWidth() == 0 || dialogView.getHeight() == 0) {
            return;
        }
        canvas.save();
        canvas.translate(rootViewInfo.getRect().left, rootViewInfo.getRect().top);
        // Switch to main thread and submit synchronous drawing task.
        PoolProvider.submitMainThreadTask(() -> {
            rootViewInfo.getView().draw(canvas);
            return null;
        }).get();
        canvas.restore();
    }
}
