package com.instabug.library.diagnostics.di

import com.instabug.library.diagnostics.IBGDiagnosticsManager
import com.instabug.library.diagnostics.IBGDiagnosticsManagerImpl
import com.instabug.library.diagnostics.network.IBGDiagnosticsSyncManager
import com.instabug.library.diagnostics.network.IBGDiagnosticsSyncManagerImpl
import com.instabug.library.networkv2.INetworkManager
import com.instabug.library.networkv2.NetworkManager
import com.instabug.library.util.threading.PoolProvider
import java.util.concurrent.Executor

object DiagnosticsServiceLocator {

    @Synchronized
    fun getIBGDiagnosticsSyncManager(): IBGDiagnosticsSyncManager = IBGDiagnosticsSyncManagerImpl()

    @JvmStatic
    @Synchronized
    fun getDiagnosticsManager(): IBGDiagnosticsManager = IBGDiagnosticsManagerImpl()

    @JvmStatic
    fun getNetworkManager(): INetworkManager {
        return NetworkManager()
    }

    @Synchronized
    fun getDiagnosticsExecutor(): Executor =
        PoolProvider.getSingleThreadExecutor("ibg-diagnostics-executor")
}