package com.instabug.library;

/**
 * @author mSobhy
 */
public class Feature {

    /**
     * An enum to specify what a certain {@link Feature} state is
     *
     * @see InstabugFeaturesManager#setFeatureState(String, State)
     * @see InstabugFeaturesManager#getFeatureState(Object)
     */
    public enum State {
        /**
         * Specifies that a feature is enabled
         *
         * @see InstabugFeaturesManager#setFeatureState(String, State)
         * @see InstabugFeaturesManager#getFeatureState(Object)
         */
        ENABLED,
        /**
         * Specifies that a feature is disabled
         *
         * @see InstabugFeaturesManager#setFeatureState(String, State)
         * @see InstabugFeaturesManager#getFeatureState(Object)
         */
        DISABLED
    }
}
