package com.instabug.library.visualusersteps;

import static com.instabug.library.model.StepType.TAB_SELECT;

import com.google.android.material.tabs.TabLayout;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;

public class InstabugOnTabSelectedListener implements TabLayout.BaseOnTabSelectedListener {

    private final String screenName;

    public InstabugOnTabSelectedListener(String screenName) {
        this.screenName = screenName;
    }

    @Override
    public void onTabSelected(TabLayout.Tab tab) {
        CoreServiceLocator.getReproStepsProxy().addVisualUserStep(
                TAB_SELECT,
                screenName + " - " + tab.getClass().getSimpleName() + " #" + (tab.getPosition() + 1),
                tab.getClass().getName(),
                null);
    }

    @Override
    public void onTabUnselected(TabLayout.Tab tab) {
    }

    @Override
    public void onTabReselected(TabLayout.Tab tab) {
    }
}
