package com.instabug.library.util.threading

import android.os.Process
import com.instabug.library.apichecker.ReturnableRunnable
import com.instabug.library.internal.servicelocator.CoreServiceLocator
import java.util.concurrent.LinkedBlockingQueue
import java.util.concurrent.TimeUnit

class MonitoredSingleThreadExecutor(private val monitoringHelper: IBGQueueMonitoringHelper = CoreServiceLocator.getQueueMonitoringHelper()) :
	ReturnableSingleThreadExecutor(
		"monitored-single-executor",
		15L,
		TimeUnit.SECONDS,
		LinkedBlockingQueue(),
		PriorityThreadFactory("monitored-single-executor", Process.THREAD_PRIORITY_BACKGROUND)
	) {
	override fun execute(command: Runnable?) {
		monitoringHelper.onJobEnqueued(command.hashCode().toString())
		super.execute(runDefensive(command))
	}

	override fun <T> executeAndGet(runnable: ReturnableRunnable<T>?): T? {
		monitoringHelper.onJobEnqueued(runnable.hashCode().toString())
		return super.executeAndGet(runnable)
	}

	override fun beforeExecute(t: Thread?, r: Runnable?) {
		super.beforeExecute(t, r)
		monitoringHelper.onJobDequeued(r?.hashCode()?.toString())
	}

	override fun afterExecute(r: Runnable?, t: Throwable?) {
		super.afterExecute(r, t)
		monitoringHelper.onJobCompleted(r.hashCode().toString())
	}
}