package com.instabug.library.session;

import android.content.Context;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;

import com.instabug.library.internal.data.DataSource;
import com.instabug.library.model.session.SessionMapper;
import com.instabug.library.model.session.SessionsBatchDTO;
import com.instabug.library.networkv2.NetworkManager;
import com.instabug.library.networkv2.RequestResponse;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.networkv2.request.RequestType;
import com.instabug.library.util.NetworkUtils;

import org.json.JSONObject;

public class SessionsRemoteDataSource extends DataSource<SessionsBatchDTO, Void> {

    private final NetworkManager networkManager;
    private final NetworkUtils networkUtils;


    private static SessionsRemoteDataSource instance;

    public static synchronized SessionsRemoteDataSource getInstance(@NonNull Context context) {
        if (instance == null) {
            instance = new SessionsRemoteDataSource(context);
        }

        return instance;
    }

    private SessionsRemoteDataSource(@NonNull Context context) {
        this.networkManager = new NetworkManager();
        this.networkUtils = new NetworkUtils(context);
    }

    @Override
    public void saveOrUpdate(SessionsBatchDTO entity, Request.Callbacks<RequestResponse, Throwable> callback) {
        JSONObject jsonObject = SessionMapper.toJson(entity);
        Request request = SessionMapper.toRequest(jsonObject);
        networkManager.doRequestOnSameThread(RequestType.NORMAL, request, new Request.Callbacks<RequestResponse, Throwable>() {
            @Override
            public void onSucceeded(RequestResponse response) {
                callback.onSucceeded(response);
            }

            @Override
            public void onFailed(Throwable error) {
                callback.onFailed(error);
            }
        });
    }
}
