package com.instabug.library.networkinterception.config

import org.json.JSONArray

interface IBGNetworkInterceptionConfigurationProvider {

    /**
     * Sets W3C external trace id feature availability percentage
     *
     * @param percentage set's the feature availability percentage
     */
    fun setW3CNetworkExternalTraceIdFeatureAvailabilityPercentage(percentage: Double)

    /**
     * Gets W3C external trace id feature enablement state.
     *
     * @return true if enabled false otherwise
     */
    fun isW3CNetworkExternalTraceIdEnabled(): Boolean

    /**
     * generated W3C external trace id attaching feature BE state
     */
    var isAttachingGeneratedW3CExternalTraceIdFeatureAvailable: Boolean

    /**
     * returns generated W3C external trace id attaching enablement state.
     */
    val isAttachingGeneratedW3CExternalTraceIdEnabled: Boolean

    /**
     * captured W3C external trace id attaching feature BE state.
     */
    var isAttachingCapturedW3CExternalTraceIdFeatureAvailable: Boolean

    /**
     * returns captured W3C external trace id attaching enablement state.
     */
    val isAttachingCapturedW3CExternalTraceIdEnabled: Boolean

    /**
     * Sets network auto masking feature availability percentage
     *
     * @param percentage set's the feature availability percentage
     */
    fun setAutoMaskingFeatureAvailabilityPercentage(percentage: Double)

    /**
     * Gets Auto masking feature availability state.
     *
     * @return true if enabled false otherwise
     */
    fun isAutoMaskingAvailable(): Boolean

    /**
     * returns network auto masking SDK enablement state.
     */
    var isAutoMaskingSDKEnabled: Boolean

    /**
     * returns network auto masking feature enablement state.
     */
    val isAutoMaskingEnabled: Boolean

    /**
     * returns the header keys that will be masked provided by BE.
     */
    var autoMaskingBEHeaderKeys: Set<String>

    /**
     * returns the query keys that will be masked provided by BE.
     */
    var autoMaskingBEQueryKeys: Set<String>

    fun resetAutoMasking()

    fun reset()
}
