package com.instabug.library.internal.video;

import static com.instabug.library.internal.video.RequestPermissionActivity.KEY_IS_INITIAL;
import static com.instabug.library.internal.video.RequestPermissionActivity.KEY_IS_VIDEO;
import static com.instabug.library.internal.video.RequestPermissionActivity.REQUEST_MEDIA_PROJECTION_PERMISSION;

import android.app.Activity;
import android.content.Intent;

import androidx.annotation.Nullable;

import com.instabug.library.screenshot.ScreenshotCaptor;

public class RequestPermissionActivityLauncher {
    public static void start(Activity currentActivity, boolean isVideo, boolean isInitial,
                             @Nullable ScreenshotCaptor.CapturingCallback screenshotCapturingListener) {
        Intent intent = new Intent(currentActivity, RequestPermissionActivity.class);
        intent.putExtra(KEY_IS_VIDEO, isVideo);
        intent.putExtra(KEY_IS_INITIAL, isInitial);
        currentActivity.overridePendingTransition(0, 0);
        currentActivity.startActivityForResult(intent, REQUEST_MEDIA_PROJECTION_PERMISSION);
        RequestPermissionActivity.screenshotCapturingListener = screenshotCapturingListener;
    }
}
