package com.instabug.library.internal.storage.cache.dbv2.migration

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.internal.storage.DiskUtils
import com.instabug.library.internal.storage.cache.dbv2.IBGDbContract.AppTerminationEntry
import com.instabug.library.internal.storage.cache.dbv2.IBGEncryptedDbVersions.DB_V9

class DBMigrationV9(override val db: SQLiteDatabase) : BaseDBMigrationImpl(db) {

    override val previous: BaseDbMigration by lazy { DBMigrationV8(db) }

    override val version: Int
        get() = DB_V9

    override fun execute() = runLogic {
        with(db) {
            execSQL(AppTerminationEntry.DROP_TABLE)
            DiskUtils.deleteAppTerminationsStateFiles()
            execSQL(AppTerminationEntry.CREATE_TABLE)
            execSQL("DROP TABLE IF EXISTS non_fatal")
            execSQL("DROP TABLE IF EXISTS non_fatal_occurrence")
        }
    }
}
