package com.instabug.library.internal.storage.cache.dbv2.migration

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.internal.storage.cache.dbv2.IBGDbContract
import com.instabug.library.internal.storage.cache.dbv2.IBGEncryptedDbVersions

class DBMigrationV16(override val db: SQLiteDatabase) : BaseDBMigrationImpl(db) {

    override val previous: BaseDbMigration? by lazy { DBMigrationV15(db) }
    override val version: Int
        get() = IBGEncryptedDbVersions.DB_V16


    override fun execute() {
        runLogic {
            db.execSQL(
                "ALTER TABLE ${IBGDbContract.BugEntry.TABLE_NAME} ADD COLUMN ${IBGDbContract.BugEntry.COLUMN_ACTIONABLE_CONSENT}"
                        + "${IBGDbContract.TEXT_TYPE} DEFAULT NULL"
            )
        }
    }

}