package com.instabug.library.internal.storage.cache.db.migrations

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.internal.storage.cache.db.InstabugDbContract
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.APMSessionMetaDataEntry
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.APMWebViewTraceEntry

class Migration_46_47 : Migration {
    override fun migrate(db: SQLiteDatabase?) {
        db?.apply {
            createAPMWebViewTracesTable()
            addWebViewTraceFieldsToAPMSessionMetadata()
        }
    }

    private fun SQLiteDatabase.createAPMWebViewTracesTable() {
        execSQL(APMWebViewTraceEntry.CREATE_TABLE_QUERY)
    }

    private fun SQLiteDatabase.addWebViewTraceFieldsToAPMSessionMetadata() {
        execSQL(addAPMSessionMetadataIntegerColumn(APMSessionMetaDataEntry.COLUMN_WEB_VIEW_TRACES_TOTAL_COUNT))
        execSQL(addAPMSessionMetadataIntegerColumn(APMSessionMetaDataEntry.COLUMN_WEB_VIEW_TRACES_DROPPED_COUNT))
    }

    private fun addAPMSessionMetadataIntegerColumn(columnName: String) =
        "ALTER TABLE ${APMSessionMetaDataEntry.TABLE_NAME} ADD COLUMN $columnName " +
                "${InstabugDbContract.INTEGER_TYPE} ${InstabugDbContract.DEFAULT} ${APMSessionMetaDataEntry.COUNT_DEFAULT_VALUE}"
}