package com.instabug.library.internal.storage.cache.db.migrations;

import android.database.sqlite.SQLiteDatabase;

import com.instabug.library.internal.storage.cache.db.InstabugDBVersions;
import com.instabug.library.internal.storage.cache.db.InstabugDbContract;

/**
 * Allows the database to migrate from version 28 to version 29
 * <p>
 * Schemas are defined in {@link InstabugDbContract}. Any changes to these schemas will require
 * a migration.
 *
 * @see InstabugDBVersions
 */
public class Migration_28_29 implements Migration {

    @Override
    public void migrate(SQLiteDatabase db) {
        db.execSQL("ALTER TABLE " + InstabugDbContract.SurveyEntry.TABLE_NAME
                + " ADD COLUMN " + InstabugDbContract.SurveyEntry.COLUMN_SURVEY_IS_DISMISSIBLE + " BOOLEAN"
                + " DEFAULT 1");
    }
}
