package com.instabug.library.internal.servicelocator;

import java.util.HashMap;
import java.util.Map;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;

/**
 * A ServiceRegistry that represents a group of unique objects instances. This ServiceRegistry does
 * not allow duplicate services.
 */
@RestrictTo(RestrictTo.Scope.LIBRARY_GROUP)
public class SingleInstanceServiceRegistry implements ServiceRegistry {

    private final Map<Class<?>, Object> serviceMap;

    @RestrictTo(RestrictTo.Scope.LIBRARY_GROUP)
    public SingleInstanceServiceRegistry() {
        this.serviceMap = new HashMap<>();
    }

    @Override
    @Nullable
    public <T> T get(@NonNull Class<T> serviceType) {
        if (serviceMap.containsKey(serviceType)) {
            Object service = serviceMap.get(serviceType);
            return serviceType.cast(service);
        }
        return null;
    }

    @Override
    public <T> void add(@NonNull T service) {
        if (!serviceMap.containsKey(service.getClass())) {
            serviceMap.put(service.getClass(), service);
        }
    }

    @Override
    public void clear() {
        serviceMap.clear();
    }
}
