package com.instabug.library.internal.filestore

import java.util.concurrent.Future

interface SpansFileDataStore<Data, Dir : SpansDirectory<SpanDir>, SpanDir : Directory> {
    fun store(log: Data)
    fun <Out> retrieve(
        aggregator: DataAggregator<Out>,
        spanSelector: SpanSelector<Dir, SpanDir>
    ): Future<Out?>

    fun clear()
    fun delete()
}

interface MultiSpanOpsFileDataStore<Data, Dir : SpansDirectory<SpanDir>, SpanDir : Directory> :
    SpansFileDataStore<Data, Dir, SpanDir> {
    fun <Out> retrieve(
        aggregator: DataAggregator<Out>,
        spansSelector: MultiSpanSelector<Dir, SpanDir>
    ): Future<List<Out?>>
    fun delete(spansSelector: MultiSpanSelector<Dir, SpanDir>)
}

interface SpansFileDataStoreLifecycle<Dir : SpansDirectory<*>> {
    fun init(operationsDirectory: Dir): Future<Boolean>
    fun onSpanStarted(spanId: String)
    fun cleanse(): Future<Boolean>
    fun onSpanEnded()
    fun shutdown(): Future<Boolean>
}
