package com.instabug.library.internal.dataretention.core;

import java.util.Collection;

import androidx.annotation.NonNull;

public interface PolicyCollector<T extends DisposalPolicy<?>> {

    /**
     * Collects all disposal policies defined for a certain
     * type of data storage (i.e. SQLite, Files, etc...)
     *
     * @return the collection of disposal policies
     */
    @NonNull
    Collection<T> collect();
}
