package com.instabug.library.internal.dataretention.core;

import java.util.Collection;

import androidx.annotation.NonNull;

/**
 * Evaluates whether a {@link Record} should be marked as disposable or not.
 */
public abstract class DataInspector<T extends DisposalPolicy<?>> {

    /**
     * the collection of disposal policies which will be be used to evaluate the disposable records
     */
    @NonNull
    protected final PolicyCollector<T> collector;

    protected DataInspector(@NonNull PolicyCollector<T> collector) {
        this.collector = collector;
    }

    /**
     * wraps all disposable {@link Record}s defined in a {@link DisposalPolicy}
     * in a collection of disposables
     *
     * @return a collection of records that needs to be disposed
     */
    @NonNull
    public abstract Collection<Disposable> getDisposables();
}
