package com.instabug.library.diagnostics.diagnostics_db.migration

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.Constants
import com.instabug.library.diagnostics.diagnostics_db.CustomTracesAttributesEntry
import com.instabug.library.diagnostics.diagnostics_db.CustomTracesEntry
import com.instabug.library.diagnostics.diagnostics_db.NonFatalEntry
import com.instabug.library.diagnostics.diagnostics_db.NonFatalOccurrenceEntry
import com.instabug.library.diagnostics.diagnostics_db.SDKEventsEntry
import com.instabug.library.internal.storage.DiskUtils
import com.instabug.library.util.InstabugSDKLogger
import com.instabug.library.util.extenstions.runOrLogError


fun destructiveMigration(db: SQLiteDatabase?) {
    runCatching {
        DiskUtils.deleteNonfatalStateFiles()
        dropAllTables(db)
        createDBTables(db)
    }.onFailure {
        InstabugSDKLogger.e(Constants.LOG_TAG, "Failed running destructive migration")
    }
}

fun dropAllTables(db: SQLiteDatabase?) = db?.runOrLogError {
    execSQL(SDKEventsEntry.DROP_TABLE_QUERY)
    execSQL(CustomTracesEntry.DROP_TABLE_QUERY)
    execSQL(CustomTracesAttributesEntry.DROP_TABLE_QUERY)
    execSQL(NonFatalEntry.DROP_TABLE)
    execSQL(NonFatalOccurrenceEntry.DROP_TABLE)
}


fun createDBTables(db: SQLiteDatabase?) {
    db?.runOrLogError {
        execSQL(SDKEventsEntry.CREATE_TABLE)
        execSQL(CustomTracesEntry.CREATE_TABLE)
        execSQL(CustomTracesAttributesEntry.CREATE_TABLE)
        execSQL(NonFatalEntry.CREATE_TABLE)
        execSQL(NonFatalOccurrenceEntry.CREATE_TABLE)
    }
}

