package com.instabug.library.diagnostics.customtraces.network

import androidx.annotation.VisibleForTesting
import com.instabug.library.diagnostics.customtraces.CustomTracesManager
import com.instabug.library.diagnostics.customtraces.di.CustomTracesServiceLocator
import com.instabug.library.diagnostics.customtraces.settings.CustomTracesSettingsResolver
import com.instabug.library.diagnostics.mappers.DiagnosticsRequestParam
import com.instabug.library.diagnostics.mappers.RequestParameterResolver
import com.instabug.library.networkv2.request.RequestParameter
import org.json.JSONObject

class CustomTracesRequestParamResolver : RequestParameterResolver<JSONObject> {

    private val tracesManager: CustomTracesManager
        get() = CustomTracesServiceLocator.getCustomTracesManager()
    private val tracesMapper: CustomTracesMapper =
        CustomTracesServiceLocator.getCustomTracesMapper()

    override fun toRequestParameter(): DiagnosticsRequestParam<JSONObject> =
        getCustomTraces().let { RequestParameter(CustomTracesMappingKeys.CUSTOM_TRACES, it ?: JSONObject())  to (it == null) }


    @VisibleForTesting
    fun getCustomTraces(): JSONObject? =
        tracesManager.takeIf { CustomTracesSettingsResolver.customTracesSettings?.enabled == true }
            ?.getAllTraces()
            ?.takeIf { it.isNotEmpty() }
            ?.filter { it.duration != -1L }
            ?.let(tracesMapper::toCustomTracesObject)
}