package com.instabug.library.diagnostics.customtraces.cache

import com.instabug.library.diagnostics.customtraces.model.IBGCustomTrace

interface CustomTracesDBHelper {

    /**
     * inserts a custom trace
     *
     * @param trace trace object
     */
    fun insertTrace(
        trace: IBGCustomTrace
    ): Long

    /**
     * ends custom trace
     *
     * @param traceId id of the trace in the db
     * @param duration trace duration
     *
     * @return true if trace was updated in the db successfully
     */
    fun endTrace(traceId: Long, duration: Long, endedInBG: Boolean): Boolean

    /**
     * Retrieves all traces from db
     *
     * @return traces list
     */
    fun getAllTraces(): List<IBGCustomTrace>

    /**
     * Clear all traces in the db
     */
    fun removeAll()

    /**
     * Removes traces whose duration was not set from the db
     */
    fun removeUnEndedTraces()

    /**
     * Delete oldest traces when reaching limit
     */
    fun trimToLimit(limit: Int)

    /**
     * Deletes traces from the db
     *
     * @param ids ids of the traces to be deleted
     */
    fun deleteTraces(ids: List<Long>)

    /**
     * Gets the id of the trace in the db
     *
     * @param trace trace object
     */
    fun getTraceId(trace: IBGCustomTrace): Long

    fun deleteTracesByName(tracesNames: List<String>)
}