package com.instabug.library.diagnostics

import com.instabug.library.diagnostics.customtraces.di.CustomTracesServiceLocator
import com.instabug.library.diagnostics.di.DiagnosticsServiceLocator.getDiagnosticsManager
import com.instabug.library.diagnostics.nonfatals.di.ServiceLocator
import com.instabug.library.diagnostics.sdkEvents.di.SDKEventsServiceLocator
import com.instabug.library.model.session.SessionState

object DiagnosticsSessionStateEventHandler {

    private val sdkEventsManager
        get() = SDKEventsServiceLocator.sdkEventsManager
    private val ibgDiagnosticsManager
        get() = getDiagnosticsManager()
    val customTracesManager = CustomTracesServiceLocator.getCustomTracesManager()

    private val nonFatalsManager
        get() = ServiceLocator.getNonFatalsManager()

    @JvmStatic
    fun handleSessionState(state: SessionState) {
        if (state == SessionState.START) {
            sdkEventsManager.deleteZeroCountedEvents()
            ibgDiagnosticsManager.sync()
            customTracesManager.removeUnEndedTraces()

            nonFatalsManager?.cleanStaleStateFiles()
            nonFatalsManager?.cleanNonFatalsWithNoOccurrences()
        }
    }
}