package com.instabug.library.percentagefeatures;

import androidx.annotation.VisibleForTesting;

import org.json.JSONException;
import org.json.JSONObject;

public class PercentageFeature {

    @VisibleForTesting
    static final String BE_VALUE = "be_value";
    @VisibleForTesting
    static final String SDK_VALUE = "sdk_value";

    private double beValue = 0;
    private double sdkValue = 0;


    public double getBeValue() {
        return beValue;
    }

    public void setBeValue(double beValue) {
        this.beValue = beValue;
    }

    public double getSdkValue() {
        return sdkValue;
    }

    public void setSdkValue(double sdkValue) {
        this.sdkValue = sdkValue;
    }

    public boolean isEnabled() {
        return sdkValue < beValue;
    }

    public String toJson() {
        JSONObject jsonObject = new JSONObject();

        try {
            jsonObject.put(BE_VALUE, this.beValue);
            jsonObject.put(SDK_VALUE, this.sdkValue);

            return jsonObject.toString();
        } catch (JSONException exception) {
            return "";

        }
    }

    public void fromJson(String jsonString) {
        if (jsonString != null) {
            try {
                JSONObject jsonObject = new JSONObject(jsonString);
                this.setBeValue(jsonObject.optDouble(BE_VALUE, 0.0));
                this.setSdkValue(jsonObject.optDouble(SDK_VALUE, 0.0));
            } catch (JSONException exception) {
                this.setBeValue(0);
                this.setSdkValue(0);
            }
        } else {
            this.setBeValue(0);
            this.setSdkValue(0);
        }
    }
}
