package com.instabug.library.networkv2.authorization.ispx

/**
 * A class for providing sensitive attributes for SDK requests authorization.
 * The general anatomy of this variant is receiving a random number with a specific criteria, combine
 * it on bits level with a stateful value to compose a start and end indices for a specific value.
 * The exception to that anatomy is app secret and client ID. For those, a native library is loaded
 * for obtaining these attributes from the native layer.
 */
@Suppress("MagicNumber", "FunctionName", "TooManyFunctions")
class LSP : ISP {

    init {
        runCatching { System.loadLibrary("ibg-native") }
    }

    @Volatile
    private var lACX = 0b0000001
        set(value) {
            synchronized(this) { field = value }
        }

    private fun SqAc(specs: ByteArray, start: Int, end: Int): String =
        String(specs.copyOfRange(start, (end + 1)))

    override fun Vx8Q(random: Int): String = Csqp()

    override fun Bp1C(random: Int): String {
        lACX = ((random ushr 26) shl 2) or (lACX.inv() ushr 31)
        return SqAc(
            GzGr.z91L(),
            lACX,
            lACX.rotateLeft(39) ushr 7
        )
    }

    override fun Ulvs(random: Int): String = gQlh()

    override fun UMUr(random: Int): String {
        lACX = random ushr 25
        return SqAc(
            GzGr.z91L(),
            lACX dispr 27,
            ((random dispr 2) dupr 3) ushr 25
        )
    }

    override fun BQfA(random: Int): String {
        lACX = ((lACX or random) dispr 1) ushr 24
        return SqAc(
            GzGr.z91L(),
            ((lACX ushr 1) dupr 1) dupr 3 or (lACX ushr 7),
            ((lACX dupr 1) dupr 2) displ 7
        )
    }

    override fun fPm2(): String {
        lACX = (((lACX.inv() ushr 1) dispr 2) dupr 1) dupr 1
        return SqAc(
            GzGr.z91L(),
            (lACX or (lACX.inv() ushr 7)) ushr 24,
            (lACX dupr 2) ushr 24
        )
    }

    override fun imxU(random: Int): String {
        lACX = ((random.inv() ushr 1) dupr 30) dupr 29
        return SqAc(
            GzGr.z91L(),
            (((lACX dupl 2) dupl 2) shl 1) displ 7,
            (lACX displ 2) or (((random.inv() ushr 31) shl 3) dupl 4)
        )
    }

    override fun E5QP(): String {
        lACX = (lACX.inv() ushr 31) shl 7
        return SqAc(
            GzGr.z91L(),
            lACX or ((lACX ushr 4) dupr 1),
            lACX dupr 3
        )
    }

    // Secret
    external fun Csqp(): String

    // Client
    external fun gQlh(): String
}
