@file:Suppress("MagicNumber", "FunctionName", "LongMethod", "ReturnCount")

package com.instabug.library.networkv2.authorization.ispx

private object UNINITIALIZED

@Volatile
private var ryPk: Any = UNINITIALIZED

/**
 * Disposing most significant bits keeping on [keep] bits count of the least significant ones.
 * For example, consider the following representation
 * 01110000101010100011000100011011
 * calling displ 3 will keep the 3 least significant bits disposing the rest. The result would be
 * 00000000000000000000000000000011
 * @param [keep] the count of least significant bits to keep
 * @return the [Int] representation of the representation after disposing.
 */
internal infix fun Int.displ(keep: Int) = (this shl (32 - keep)) ushr (32 - keep)

/**
 * Disposing least significant bits keeping on [keep] bits count of the most significant ones.
 * For example, consider the following representation
 * 01110000101010100011000100011011
 * calling dispr 3 will keep the 3 most significant bits disposing the rest. The result would be
 * 01100000000000000000000000000000
 * @param [keep] the count of most significant bits to keep
 * @return the [Int] representation of the bits after disposing.
 */
internal infix fun Int.dispr(keep: Int) = (this ushr (32 - keep)) shl (32 - keep)

/**
 * Duplicating the bits at a specific [distance] to the left
 * Consider the following representation
 * 00000000000000000000000000000011
 * Calling dupl 4 on it results in
 * 00000000000000000000000000011011
 * @param [distance] the bits count at which the bits should be duplicated
 * @return the [Int] representation of the representation after duplication.
 */
internal infix fun Int.dupl(distance: Int) = this or (this shl distance)

/**
 * Duplicating the bits at a specific [distance] to the right
 * Consider the following representation
 * 01100000000000000000000000000000
 * Calling dupr 4 on it results in
 * 01101100000000000000000000000000
 * @param [distance] the bits count at which the bits should be duplicated
 * @return the [Int] representation of the representation after duplication.
 */
internal infix fun Int.dupr(distance: Int) = this or (this ushr distance)

/**
 * A generator that's responsible for generating a [ByteArray] that contains
 * all necessary attributes for
 * 1. auth header generation. Including app secret, client id & Authorization header key
 * 2. Content type header key
 * 3. Accepted charset header key & value
 */
object GzGr {
    fun z91L(): ByteArray {
        val spec1 = ryPk
        if (spec1 != UNINITIALIZED) return spec1 as ByteArray
        synchronized(this) {
            val spec2 = ryPk
            if (spec2 != UNINITIALIZED) return spec2 as ByteArray
            return tZYW()
        }
    }

    /**
     * Fills the [ryPk] byte array which holds the byte representation of all necessary data.
     * The general anatomy of the method is to mutate an initial byte to a target representation.
     */
    private fun tZYW(): ByteArray {
        val spec = ByteArray(145)
        var mutator = 0b00000011
        mutator = (mutator shl 4) or (mutator ushr 1)
        spec[0] = mutator.toByte()
        spec[6] = mutator.toByte()
        spec[9] = mutator.toByte()
        spec[22] = mutator.toByte()
        spec[24] = mutator.toByte()
        spec[46] = mutator.toByte()
        spec[64] = mutator.toByte()
        spec[73] = mutator.toByte()
        mutator = mutator or ((mutator displ 1) shl 3)
        spec[1] = mutator.toByte()
        spec[27] = mutator.toByte()
        spec[32] = mutator.toByte()
        spec[44] = mutator.toByte()
        spec[54] = mutator.toByte()
        spec[74] = mutator.toByte()
        spec[89] = mutator.toByte()
        mutator = ((mutator dispr 28) shl 1) or ((mutator displ 1) dupl 2)
        spec[2] = mutator.toByte()
        spec[11] = mutator.toByte()
        spec[34] = mutator.toByte()
        spec[129] = mutator.toByte()
        spec[138] = mutator.toByte()
        spec[117] = mutator.toByte()
        spec[124] = mutator.toByte()
        mutator = (mutator dispr 27) or (mutator displ 1)
        spec[3] = mutator.toByte()
        spec[19] = mutator.toByte()
        spec[59] = mutator.toByte()
        spec[61] = mutator.toByte()
        spec[68] = mutator.toByte()
        spec[75] = mutator.toByte()
        spec[79] = mutator.toByte()
        spec[81] = mutator.toByte()
        spec[95] = mutator.toByte()
        spec[135] = mutator.toByte()
        spec[104] = mutator.toByte()
        spec[109] = mutator.toByte()
        mutator = (mutator ushr 1) dupr 3
        spec[4] = mutator.toByte()
        spec[5] = mutator.toByte()
        spec[25] = mutator.toByte()
        spec[28] = mutator.toByte()
        spec[31] = mutator.toByte()
        spec[33] = mutator.toByte()
        spec[78] = mutator.toByte()
        spec[82] = mutator.toByte()
        mutator = mutator or (mutator ushr 5)
        spec[7] = mutator.toByte()
        spec[23] = mutator.toByte()
        spec[38] = mutator.toByte()
        spec[58] = mutator.toByte()
        spec[92] = mutator.toByte()
        mutator = ((mutator shl 1) dispr 27) or ((mutator ushr 4) shl 1)
        spec[8] = mutator.toByte()
        spec[15] = mutator.toByte()
        spec[53] = mutator.toByte()
        spec[65] = mutator.toByte()
        spec[67] = mutator.toByte()
        spec[76] = mutator.toByte()
        mutator = (mutator dispr 27) or (mutator displ 2)
        spec[10] = mutator.toByte()
        spec[85] = mutator.toByte()
        mutator = ((mutator ushr 1) dispr 28) or ((mutator shl 1) displ 3)
        spec[12] = mutator.toByte()
        spec[13] = mutator.toByte()
        spec[35] = mutator.toByte()
        spec[37] = mutator.toByte()
        spec[43] = mutator.toByte()
        spec[56] = mutator.toByte()
        spec[69] = mutator.toByte()
        spec[90] = mutator.toByte()
        mutator = mutator or (mutator ushr 5)
        spec[14] = mutator.toByte()
        spec[40] = mutator.toByte()
        spec[42] = mutator.toByte()
        spec[47] = mutator.toByte()
        spec[71] = mutator.toByte()
        mutator = ((mutator shl 1) dispr 27) dupr 5
        spec[16] = mutator.toByte()
        spec[51] = mutator.toByte()
        spec[55] = mutator.toByte()
        spec[57] = mutator.toByte()
        spec[70] = mutator.toByte()
        spec[83] = mutator.toByte()
        spec[127] = mutator.toByte()
        spec[128] = mutator.toByte()
        mutator = ((mutator dispr 27) ushr 1) dupr 1
        spec[17] = mutator.toByte()
        spec[18] = mutator.toByte()
        spec[36] = mutator.toByte()
        spec[39] = mutator.toByte()
        spec[41] = mutator.toByte()
        spec[50] = mutator.toByte()
        spec[60] = mutator.toByte()
        spec[62] = mutator.toByte()
        spec[144] = mutator.toByte()
        mutator = (mutator dispr 28) or ((mutator ushr 5) shl 1)
        spec[20] = mutator.toByte()
        spec[21] = mutator.toByte()
        spec[45] = mutator.toByte()
        spec[72] = mutator.toByte()
        spec[77] = mutator.toByte()
        spec[80] = mutator.toByte()
        spec[86] = mutator.toByte()
        spec[87] = mutator.toByte()
        spec[91] = mutator.toByte()
        mutator = mutator shl 1
        spec[26] = mutator.toByte()
        spec[29] = mutator.toByte()
        spec[66] = mutator.toByte()
        spec[94] = mutator.toByte()
        mutator = (mutator dispr 27) ushr 1
        spec[30] = mutator.toByte()
        spec[48] = mutator.toByte()
        spec[49] = mutator.toByte()
        spec[88] = mutator.toByte()
        mutator = mutator dupr 4
        spec[52] = mutator.toByte()
        spec[63] = mutator.toByte()
        spec[84] = mutator.toByte()
        spec[93] = mutator.toByte()
        mutator = (mutator ushr 5) dupl 6
        spec[126] = mutator.toByte()
        spec[96] = mutator.toByte()
        mutator = ((mutator dupr 1) dupr 1) dispr 28
        spec[130] = mutator.toByte()
        spec[123] = mutator.toByte()
        mutator = mutator or ((mutator dispr 26) ushr 4)
        spec[131] = mutator.toByte()
        spec[139] = mutator.toByte()
        spec[98] = mutator.toByte()
        spec[105] = mutator.toByte()
        spec[116] = mutator.toByte()
        spec[119] = mutator.toByte()
        mutator = ((mutator ushr 2) displ 4) or ((mutator ushr 1) dispr 27)
        spec[132] = mutator.toByte()
        spec[120] = mutator.toByte()
        spec[143] = mutator.toByte()
        mutator = ((mutator shl 1) dispr 26) or ((mutator ushr 2) displ 2)
        spec[133] = mutator.toByte()
        spec[113] = mutator.toByte()
        mutator = ((mutator dispr 30) ushr 3) or ((mutator displ 2) shl 5)
        spec[134] = mutator.toByte()
        spec[99] = mutator.toByte()
        mutator = ((mutator dispr 27) dupr 1) or ((mutator displ 4) ushr 2)
        spec[136] = mutator.toByte()
        spec[101] = mutator.toByte()
        mutator = mutator or ((mutator displ 2) dupr 1)
        spec[137] = mutator.toByte()
        mutator = (mutator dispr 28) or ((mutator ushr 6) dupl 2)
        spec[97] = mutator.toByte()
        mutator = (mutator dispr 27) or ((mutator ushr 5) dupl 2)
        spec[100] = mutator.toByte()
        spec[107] = mutator.toByte()
        spec[114] = mutator.toByte()
        mutator = mutator xor (mutator ushr 4)
        spec[102] = mutator.toByte()
        spec[106] = mutator.toByte()
        mutator = (mutator ushr 2) dupl 2
        spec[103] = mutator.toByte()
        mutator = (mutator dispr 27) or ((mutator dispr 28) ushr 3)
        spec[108] = mutator.toByte()
        spec[115] = mutator.toByte()
        spec[118] = mutator.toByte()
        mutator = (((mutator displ 2) shl 3) dupl 2) or ((mutator displ 2) shl 1)
        spec[121] = mutator.toByte()
        spec[141] = mutator.toByte()
        mutator = (mutator ushr 6) or ((mutator dupr 1) dispr 29)
        spec[122] = mutator.toByte()
        mutator = ((mutator dispr 27) dupr 3) or (mutator displ 1)
        spec[110] = mutator.toByte()
        mutator = (mutator dispr 27) dupr 2
        spec[111] = mutator.toByte()
        mutator = ((mutator ushr 1) dispr 29) or ((mutator ushr 2) displ 2)
        spec[125] = mutator.toByte()
        mutator = mutator dispr 27
        spec[112] = mutator.toByte()
        mutator = ((mutator shl 1) dupr 2) dupr 4
        spec[140] = mutator.toByte()
        mutator = (mutator dispr 26) or (((mutator displ 1) shl 1) dupl 1)
        spec[142] = mutator.toByte()
        ryPk = spec
        return spec
    }
}
