package com.instabug.library.model.session.config;

import android.annotation.SuppressLint;

import androidx.annotation.NonNull;

import com.instabug.library.internal.utils.stability.execution.ReturnableExecutable;
import com.instabug.library.internal.utils.stability.handler.exception.ExceptionHandler;

import org.json.JSONObject;

public class SessionsConfigMapper {

    private static final String TAG = "SessionsConfigMapper";

    private SessionsConfigMapper() {
        // Utility classes should not be instantiable
    }

    @NonNull
    @SuppressLint("ERADICATE_RETURN_NOT_NULLABLE")
    public static SessionsConfig map(@NonNull final String json) {
        return new ExceptionHandler()
                .withPenaltyLog(TAG)
                .executeAndGet(new ReturnableExecutable<SessionsConfig>() {
                    @Override
                    public SessionsConfig execute() throws Exception {
                        return map(new JSONObject(json));
                    }
                }, SessionsConfig.createDefault());
    }

    @NonNull
    @SuppressLint("ERADICATE_RETURN_NOT_NULLABLE")
    public static SessionsConfig map(@NonNull final JSONObject json) {
        return new ExceptionHandler()
                .withPenaltyLog(TAG)
                .executeAndGet(new ReturnableExecutable<SessionsConfig>() {
                    @Override
                    public SessionsConfig execute() {
                        int defaultInterval = SessionsConfig.Defaults.SYNC_INTERVALS;
                        int defaultSessions = SessionsConfig.Defaults.MAX_SESSIONS;
                        int defaultMode = SessionsConfig.Defaults.SYNC_MODE;
                        // deserialize
                        int interval = json.optInt(SessionsConfigParameter.SYNC_INTERVAL, defaultInterval);
                        int max = json.optInt(SessionsConfigParameter.MAX_SESSIONS_PER_REQUEST, defaultSessions);
                        int mode = json.optInt(SessionsConfigParameter.SYNC_MODE, defaultMode);
                        return new SessionsConfig(interval, max, mode);
                    }
                }, SessionsConfig.createDefault());
    }

    @NonNull
    @SuppressLint("ERADICATE_RETURN_NOT_NULLABLE")
    public static String map(@NonNull final SessionsConfig config) {
        return new ExceptionHandler()
                .withPenaltyLog(TAG)
                .executeAndGet(new ReturnableExecutable<String>() {
                    @Override
                    public String execute() throws Exception {
                        int interval = config.getSyncIntervalsInMinutes();
                        int max = config.getMaxSessionsPerRequest();
                        int mode = config.getSyncMode();
                        // serialize
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put(SessionsConfigParameter.SYNC_INTERVAL, interval);
                        jsonObject.put(SessionsConfigParameter.MAX_SESSIONS_PER_REQUEST, max);
                        jsonObject.put(SessionsConfigParameter.SYNC_MODE, mode);
                        return jsonObject.toString();
                    }
                }, "{}");
    }
}
