package com.instabug.library.internal.storage.cache.db.migrations

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.diagnostics.diagnostics_db.BOOLEAN_TYPE
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.AnrEntry.COLUMN_ANR_VERSION
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.AnrEntry.COLUMN_EARLY_ANR
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.AnrEntry.TABLE_NAME
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.DEFAULT
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.TEXT_TYPE

class Migration_48_49 : Migration {
    override fun migrate(db: SQLiteDatabase?) {
        db?.addAnrVersionToAnrTable()
        db?.addEarlyAnrToAnrTable()
    }

    private fun SQLiteDatabase.addAnrVersionToAnrTable() = execSQL(
        "ALTER TABLE $TABLE_NAME ADD COLUMN $COLUMN_ANR_VERSION $TEXT_TYPE $DEFAULT \"v1\""
    )

    private fun SQLiteDatabase.addEarlyAnrToAnrTable() = execSQL(
        "ALTER TABLE $TABLE_NAME ADD COLUMN $COLUMN_EARLY_ANR $BOOLEAN_TYPE $DEFAULT 0"
    )
}