package com.instabug.library.internal.storage.cache.db.migrations

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.BOOLEAN_TYPE
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.DEFAULT
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.COLUMN_V2_SESSION_SENT
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.TABLE_NAME

class Migration_47_48 : Migration {
    override fun migrate(db: SQLiteDatabase?) {
        db?.apply { addSessionV2SentToSessionTable() }
    }

    private fun SQLiteDatabase.addSessionV2SentToSessionTable() = execSQL(
        "ALTER TABLE $TABLE_NAME ADD COLUMN $COLUMN_V2_SESSION_SENT $BOOLEAN_TYPE $DEFAULT 1"
    )

}