package com.instabug.library.internal.storage.cache.db.migrations;

import android.database.sqlite.SQLiteDatabase;

import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.internal.storage.cache.db.InstabugDBVersions;
import com.instabug.library.internal.storage.cache.db.InstabugDbContract;

/**
 * Allows the database to migrate from version 28 to version 29
 * <p>
 * Schemas are defined in {@link InstabugDbContract}. Any changes to these schemas will require
 * a migration.
 *
 * @see InstabugDBVersions
 */
public class Migration_29_30 implements Migration {

    @Override
    public void migrate(SQLiteDatabase db) {
        dropTables(db);
        createTables(db);
        clearStateFiles();
    }

    private void dropTables(SQLiteDatabase db) {
        db.execSQL(InstabugDbContract.CrashEntry.DROP_TABLE);
        db.execSQL(InstabugDbContract.AnrEntry.DROP_TABLE);
        db.execSQL(InstabugDbContract.BugEntry.DROP_TABLE);
        db.execSQL(InstabugDbContract.NDKCrashEntry.DROP_TABLE);
    }

    private void createTables(SQLiteDatabase db) {
        db.execSQL(InstabugDbContract.BugEntry.CREATE_TABLE);
        db.execSQL(InstabugDbContract.CrashEntry.CREATE_TABLE);
        db.execSQL(InstabugDbContract.AnrEntry.CREATE_TABLE);
        db.execSQL(InstabugDbContract.NDKCrashEntry.CREATE_TABLE);
    }

    private void clearStateFiles() {
        DiskUtils.deleteCrashStateFiles();
    }
}
