package com.instabug.library.internal.storage.cache.db.migrations;

import android.database.sqlite.SQLiteDatabase;

import androidx.annotation.VisibleForTesting;

import com.instabug.library.internal.storage.cache.db.InstabugDbContract;

import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.AnrEntry.COLUMN_ANR_LONG_MESSAGE;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.AnrEntry.COLUMN_ANR_MAIN_THREAD_DATA;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.AnrEntry.COLUMN_ANR_REST_OF_THREADS_DATA;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.AnrEntry.COLUMN_ANR_TEMPORARY_SERVER_TOKEN;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.AnrEntry.COLUMN_ANR_UPLOAD_STATE;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.AnrEntry.COLUMN_ID;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.AnrEntry.COLUMN_STATE;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.COMMA_SEP;
public class Migration_24_25 implements Migration {


    @Override
    public void migrate(SQLiteDatabase db) {

        //Add column COLUMN_PRODUCTION_USAGE to sessions table
        db.execSQL("Alter TABLE " +
                InstabugDbContract.SessionEntry.TABLE_NAME +
                " ADD COLUMN " +
                InstabugDbContract.SessionEntry.COLUMN_PRODUCTION_USAGE +
                InstabugDbContract.TEXT_TYPE);

        // SQLite does not fully support ALTER TABLE statements. The workaround to altering an
        // existing column's type is to create a new table with a temporary name, copy everything to
        // the new table, drop the old table and then rename the new table to its original name.
        String originalTableName = InstabugDbContract.AnrEntry.TABLE_NAME;
        String tempTableName = InstabugDbContract.AnrEntry.TABLE_NAME + "_temp";
        // create new table with temp name.
        createTable(db, tempTableName);
        // copy values from old table to new table.
        copyValues(db, originalTableName, tempTableName, getColumnsCommaSeparated());
        // drop old table.
        dropTable(db, originalTableName);
        // rename the new table to its original name.
        renameTable(db, tempTableName, originalTableName);
    }

    private void createTable(SQLiteDatabase database, String tableName) {
        database.execSQL( "CREATE TABLE IF NOT EXISTS " + tableName +
                " ( " + COLUMN_ID + " TEXT, " + COLUMN_ANR_MAIN_THREAD_DATA + " TEXT, "
                + COLUMN_ANR_REST_OF_THREADS_DATA + " TEXT, "
                + COLUMN_ANR_UPLOAD_STATE + " INTEGER, "
                + COLUMN_ANR_TEMPORARY_SERVER_TOKEN + " TEXT, "
                + COLUMN_STATE + " TEXT, " + COLUMN_ANR_LONG_MESSAGE + " TEXT DEFAULT \"\")");
    }

    @VisibleForTesting
    public void copyValues(SQLiteDatabase db, String oldTable, String newTable, String columns) {
        db.execSQL("INSERT INTO " + newTable + "(" + columns + ")"
                + " SELECT " + columns
                + " FROM " + oldTable);
    }

    private String getColumnsCommaSeparated() {
        return COLUMN_ID + COMMA_SEP
                + COLUMN_ANR_MAIN_THREAD_DATA + COMMA_SEP
                + COLUMN_ANR_REST_OF_THREADS_DATA + COMMA_SEP
                + COLUMN_ANR_UPLOAD_STATE + COMMA_SEP
                + COLUMN_ANR_TEMPORARY_SERVER_TOKEN + COMMA_SEP
                + COLUMN_STATE;
    }

    @VisibleForTesting
    public void dropTable(SQLiteDatabase db, String tableName) {
        db.execSQL("DROP TABLE IF EXISTS " + tableName);
    }
    @VisibleForTesting
    public void renameTable(SQLiteDatabase db, String oldTableName, String newTableName) {
        db.execSQL("ALTER TABLE " + oldTableName + " RENAME TO " + newTableName);
    }
}
