package com.instabug.library.encryption

import com.instabug.library.Instabug
import com.instabug.library.core.InstabugCore
import com.instabug.library.internal.storage.DiskUtils
import com.instabug.library.internal.storage.Encryptor
import com.instabug.library.util.DiskUtils.listFilesInDirectory
import com.instabug.library.util.FileUtils

object MigrationV1_V2 {

    fun run() {
        decryptAlInstabugFiles()
        encryptAlInstabugFiles()
        InstabugCore.saveEncryptorVersion(EncryptorVersions.ENCRYPTOR_V2)
    }

    private fun decryptAlInstabugFiles() {
        if (Instabug.getApplicationContext() == null) return;
        val instabugDirectory = DiskUtils.getInstabugDirectory(Instabug.getApplicationContext())
        val instabugFiles = listFilesInDirectory(instabugDirectory)
        for (file in instabugFiles) {
            if (FileUtils.isFileRelatedToBugOrCrashReport(file.path)) {
                if (!file.isDirectory) {
                    Encryptor.decrypt(file.path)
                } else if (file.isDirectory) {
                    val directoryFiles = listFilesInDirectory(file)
                    for (innerFile in directoryFiles) {
                        Encryptor.decrypt(innerFile.path)
                    }
                }
            }
        }
    }

    private fun encryptAlInstabugFiles() {
        if (Instabug.getApplicationContext() == null) return;
        val instabugDirectory = DiskUtils.getInstabugDirectory(Instabug.getApplicationContext())
        val instabugFiles = com.instabug.library.util.DiskUtils.listFilesInDirectory(instabugDirectory)
        for (file in instabugFiles) {
            if (FileUtils.isFileRelatedToBugOrCrashReport(file.path)) {
                if (!file.isDirectory) {
                    FileUtils.encryptFile(file.path)
                } else if (file.isDirectory) {
                    val directoryFiles = listFilesInDirectory(file)
                    for (innerFile in directoryFiles) {
                        FileUtils.encryptFile(innerFile.path)
                    }
                }
            }
        }
    }
}