package com.instabug.library.coreSDKChecks

import com.instabug.library.settings.SettingsManager

class CoreSDKChecks @JvmOverloads constructor(
    private val settingsManager: SettingsManager? = SettingsManager.getInstance()
) {
    private val currentAppTokenChangeHandler by lazy {
        CurrentAppTokenChangeHandler(settingsManager)
    }
    private val currentOSVersionChangeHandler by lazy {
        CurrentOSVersionChangeHandler(settingsManager)
    }
    private val currentSDKVersionChangeHandler by lazy {
        CurrentSDKVersionChangeHandler(settingsManager)
    }

    fun check(currentOsVersion: Int, sdkVersion: String) {
        currentAppTokenChangeHandler.setCurrentToken()
        currentOSVersionChangeHandler.setOsVersion(currentOsVersion)
        currentSDKVersionChangeHandler.setCurrentSdkVersion(sdkVersion)
    }
}