/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;

public class ScaleImageView
extends ImageView
implements View.OnTouchListener {
    private Context mContext;
    private float MAX_SCALE = 5.0f;
    private Matrix mMatrix;
    private final float[] mMatrixValues = new float[9];
    private int mWidth;
    private int mHeight;
    private int mIntrinsicWidth;
    private int mIntrinsicHeight;
    private float mScale;
    private float mMinScale;
    private float mPrevDistance;
    private boolean isScaling;
    private int mPrevMoveX;
    private int mPrevMoveY;
    private GestureDetector mDetector;

    /*
     * WARNING - void declaration
     */
    public ScaleImageView(Context context, AttributeSet attr2) {
        super((Context)var1_1, (AttributeSet)var2_2);
        void var2_2;
        void var1_1;
        this.mContext = var1_1;
        this.initialize();
    }

    /*
     * WARNING - void declaration
     */
    public ScaleImageView(Context context) {
        super((Context)var1_1);
        void var1_1;
        this.mContext = var1_1;
        this.initialize();
    }

    private void initialize() {
        GestureDetector.SimpleOnGestureListener simpleOnGestureListener;
        GestureDetector gestureDetector;
        ScaleImageView scaleImageView = this;
        scaleImageView.setScaleType(ImageView.ScaleType.MATRIX);
        scaleImageView.mMatrix = new Matrix();
        Drawable drawable2 = scaleImageView.getDrawable();
        if (drawable2 != null) {
            ScaleImageView scaleImageView2 = this;
            this.mIntrinsicWidth = drawable2.getIntrinsicWidth();
            scaleImageView2.mIntrinsicHeight = drawable2.getIntrinsicHeight();
            scaleImageView2.setOnTouchListener(scaleImageView2);
        }
        drawable2 = gestureDetector;
        Context context = this.mContext;
        GestureDetector.SimpleOnGestureListener simpleOnGestureListener2 = simpleOnGestureListener;
        simpleOnGestureListener = new GestureDetector.SimpleOnGestureListener(this){
            final /* synthetic */ ScaleImageView a;
            {
                void var1_1;
                this.a = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public boolean onDoubleTap(MotionEvent e2) {
                void var1_1;
                a a2 = this;
                a2.a.maxZoomTo((int)var1_1.getX(), (int)var1_1.getY());
                a2.a.cutting();
                return super.onDoubleTap((MotionEvent)var1_1);
            }
        };
        gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)simpleOnGestureListener2);
        this.mDetector = drawable2;
    }

    /*
     * WARNING - void declaration
     */
    private float distance(float x02, float x12, float y02, float y12) {
        void var4_5;
        void var3_4;
        void var0_1;
        void var2_3;
        float f2 = x02 - var2_3;
        void v12 = var0_1 = var3_4 - var4_5;
        return (float)Math.sqrt(f2 * f2 + v12 * v12);
    }

    private float dispDistance() {
        int n2 = this.mWidth;
        int n3 = this.mHeight;
        return (float)Math.sqrt(n2 * n2 + n3 * n3);
    }

    /*
     * WARNING - void declaration
     */
    public void setImageBitmap(Bitmap bm) {
        void var1_1;
        ScaleImageView scaleImageView = this;
        super.setImageBitmap((Bitmap)var1_1);
        scaleImageView.initialize();
    }

    /*
     * WARNING - void declaration
     */
    public void setImageResource(int resId) {
        void var1_1;
        ScaleImageView scaleImageView = this;
        super.setImageResource((int)var1_1);
        scaleImageView.initialize();
    }

    /*
     * WARNING - void declaration
     */
    protected boolean setFrame(int l2, int t2, int r2, int b2) {
        void var4_4;
        boolean bl;
        int n2;
        int n3;
        float f2;
        float f3;
        void var2_2;
        int n4;
        void var1_1;
        void var3_3;
        void var5_5 = var3_3 - var1_1;
        this.mWidth = var5_5;
        this.mHeight = n4 = b2 - var2_2;
        this.mMatrix.reset();
        this.mScale = f3 = (float)var5_5 / (float)this.mIntrinsicWidth;
        n4 = this.mIntrinsicHeight;
        int n5 = this.mHeight;
        if (f2 * (float)n3 > (float)n2) {
            this.mScale = f3 = (float)n5 / (float)n4;
            float f4 = f3;
            this.mMatrix.postScale(f4, f4);
            bl = (var3_3 - this.mWidth) / 2;
            n4 = 0;
        } else {
            float f5 = f3;
            this.mMatrix.postScale(f5, f5);
            n4 = (var4_4 - this.mHeight) / 2;
            bl = false;
        }
        float f6 = (float)bl;
        this.mMatrix.postTranslate(f6, (float)n4);
        this.setImageMatrix(this.mMatrix);
        this.mMinScale = f6 = this.mScale;
        n4 = this.mWidth / 2;
        n5 = this.mHeight / 2;
        this.zoomTo(f6, n4, n5);
        this.cutting();
        return super.setFrame((int)var1_1, (int)var2_2, (int)var3_3, (int)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    protected float getValue(Matrix matrix, int whichValue) {
        void var2_2;
        void var1_1;
        var1_1.getValues(this.mMatrixValues);
        return this.mMatrixValues[var2_2];
    }

    protected float getScale() {
        ScaleImageView scaleImageView = this;
        return scaleImageView.getValue(scaleImageView.mMatrix, 0);
    }

    public float getTranslateX() {
        ScaleImageView scaleImageView = this;
        return scaleImageView.getValue(scaleImageView.mMatrix, 2);
    }

    protected float getTranslateY() {
        ScaleImageView scaleImageView = this;
        return scaleImageView.getValue(scaleImageView.mMatrix, 5);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected void maxZoomTo(int x2, int y2) {
        void var2_2;
        void var1_1;
        if (this.mMinScale != this.getScale()) {
            float f2;
            float f3 = this.mMinScale;
            if (this.getScale() - f2 > 0.1f) {
                this.zoomTo(f3 / this.getScale(), (int)var1_1, (int)var2_2);
                return;
            }
        }
        ScaleImageView scaleImageView = this;
        scaleImageView.zoomTo(scaleImageView.MAX_SCALE / this.getScale(), (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void zoomTo(float scale, int x2, int y2) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.getScale() * var1_1 < this.mMinScale) {
            return;
        }
        if (var1_1 >= 1.0f && this.getScale() * var1_1 > this.MAX_SCALE) {
            return;
        }
        ScaleImageView scaleImageView = this;
        void v12 = var1_1;
        scaleImageView.mMatrix.postScale((float)v12, (float)v12);
        ScaleImageView scaleImageView2 = this;
        int n2 = scaleImageView2.mWidth;
        float f2 = -((float)n2 * var1_1 - (float)n2) / 2.0f;
        int n3 = scaleImageView2.mHeight;
        scaleImageView.mMatrix.postTranslate(f2, -((float)n3 * var1_1 - (float)n3) / 2.0f);
        scaleImageView.mMatrix.postTranslate((float)(-(var2_2 - this.mWidth / 2)) * var1_1, 0.0f);
        scaleImageView.mMatrix.postTranslate(0.0f, (float)(-(var3_3 - this.mHeight / 2)) * var1_1);
        scaleImageView.setImageMatrix(scaleImageView.mMatrix);
    }

    public void cutting() {
        int n2;
        int n3 = (int)((float)this.mIntrinsicWidth * this.getScale());
        int n4 = (int)((float)this.mIntrinsicHeight * this.getScale());
        if (this.getTranslateX() < (float)(-(n3 - this.mWidth))) {
            this.mMatrix.postTranslate(-(this.getTranslateX() + (float)n3 - (float)this.mWidth), 0.0f);
        }
        if (this.getTranslateX() > 0.0f) {
            this.mMatrix.postTranslate(-this.getTranslateX(), 0.0f);
        }
        if (this.getTranslateY() < (float)(-(n4 - this.mHeight))) {
            this.mMatrix.postTranslate(0.0f, -(this.getTranslateY() + (float)n4 - (float)this.mHeight));
        }
        if (this.getTranslateY() > 0.0f) {
            this.mMatrix.postTranslate(0.0f, -this.getTranslateY());
        }
        if (n3 < (n2 = this.mWidth)) {
            this.mMatrix.postTranslate((float)(n2 - n3) / 2.0f, 0.0f);
        }
        if (n4 < (n3 = this.mHeight)) {
            this.mMatrix.postTranslate(0.0f, (float)(n3 - n4) / 2.0f);
        }
        this.setImageMatrix(this.mMatrix);
    }

    /*
     * WARNING - void declaration
     */
    public boolean onTouchEvent(MotionEvent event) {
        block10: {
            int n2;
            void var1_1;
            block7: {
                block8: {
                    block9: {
                        if (this.mDetector.onTouchEvent((MotionEvent)var1_1)) {
                            return true;
                        }
                        void v02 = var1_1;
                        n2 = v02.getPointerCount();
                        int n3 = v02.getAction();
                        if (n3 == 0) break block7;
                        if (n3 == 1) break block8;
                        if (n3 == 2) break block9;
                        if (n3 == 5) break block7;
                        if (n3 == 6) break block8;
                        if (n3 == 261) break block7;
                        if (n3 == 262) break block8;
                        break block10;
                    }
                    if (n2 >= 2 && this.isScaling) {
                        void v12 = var1_1;
                        float f2 = v12.getX(0);
                        float f3 = v12.getX(1);
                        float f4 = v12.getY(0);
                        float f5 = v12.getY(1);
                        this.mPrevDistance = f2 = this.distance(f2, f3, f4, f5);
                        float f6 = (f2 - this.mPrevDistance) / this.dispDistance() + 1.0f;
                        int n4 = this.mWidth / 2;
                        int n5 = this.mHeight / 2;
                        this.zoomTo(f6 * f6, n4, n5);
                        this.cutting();
                    } else if (!this.isScaling) {
                        void v3 = var1_1;
                        n2 = this.mPrevMoveX - (int)var1_1.getX();
                        int n6 = this.mPrevMoveY - (int)var1_1.getY();
                        this.mPrevMoveX = (int)v3.getX();
                        this.mPrevMoveY = (int)v3.getY();
                        this.mMatrix.postTranslate((float)(-n2), (float)(-n6));
                        this.cutting();
                    }
                    break block10;
                }
                if (var1_1.getPointerCount() <= 1) {
                    this.isScaling = false;
                }
                break block10;
            }
            if (n2 >= 2) {
                void v4 = var1_1;
                float f7 = v4.getX(0);
                float f8 = v4.getX(1);
                float f9 = v4.getY(0);
                float f10 = v4.getY(1);
                this.mPrevDistance = this.distance(f7, f8, f9, f10);
                this.isScaling = true;
            } else {
                void v5 = var1_1;
                this.mPrevMoveX = (int)v5.getX();
                this.mPrevMoveY = (int)v5.getY();
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean onTouch(View v2, MotionEvent event) {
        void var2_2;
        return super.onTouchEvent((MotionEvent)var2_2);
    }
}

