/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.device;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.media.AudioManager;
import android.os.Build;
import androidx.annotation.NonNull;
import com.instabug.library.Instabug;
import com.instabug.library.internal.utils.stability.execution.ReturnableExecutable;
import com.instabug.library.internal.utils.stability.handler.exception.ExceptionHandler;
import com.instabug.library.util.InstabugSDKLogger;

public class InstabugDeviceProperties {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PackageInfo getPackageInfo(@NonNull Context context) {
        try {
            Context context2;
            if (Build.VERSION.SDK_INT < 33) return context2.getPackageManager().getPackageInfo(context2.getPackageName(), 0);
            return context2.getPackageManager().getPackageInfo(context2.getPackageName(), PackageManager.PackageInfoFlags.of((long)0L));
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        InstabugSDKLogger.d("IBG-Core", "Failed to get package info" + (Object)((Object)nameNotFoundException));
        return new PackageInfo();
    }

    public static String getAppVersion(@NonNull Context context) {
        PackageInfo packageInfo = InstabugDeviceProperties.getPackageInfo(context);
        Object object = packageInfo.versionName;
        Integer n2 = packageInfo.versionCode;
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = object;
        objectArray[1] = n2;
        return String.format("%s (%s)", objectArray2);
    }

    public static String getAppVersionName(@NonNull Context context) {
        return InstabugDeviceProperties.getPackageInfo((Context)context).versionName;
    }

    public static String getPackageName(@NonNull Context context) {
        Object object;
        try {
            object = context.getApplicationInfo().packageName;
        }
        catch (Exception exception) {
            String string2 = "Could not get information";
            InstabugSDKLogger.d("IBG-Core", "failed to get package name" + exception);
            object = string2;
        }
        return object;
    }

    @NonNull
    public static String getDeviceType() {
        return Build.MANUFACTURER + " " + Build.MODEL;
    }

    public static int getCurrentOSLevel() {
        return Build.VERSION.SDK_INT;
    }

    public static boolean isTablet(@NonNull Context context) {
        return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }

    public static boolean checkRingerIsOn(Context context) {
        Context context2 = (AudioManager)context.getSystemService("audio");
        if (context2 != null) {
            return context2.getRingerMode() == 2;
        }
        return true;
    }

    public static boolean isFirstInstall(Context context) {
        try {
            Context context2;
            return context.getPackageManager().getPackageInfo((String)InstabugDeviceProperties.getPackageName((Context)context2), (int)0).firstInstallTime == context2.getPackageManager().getPackageInfo((String)InstabugDeviceProperties.getPackageName((Context)context2), (int)0).lastUpdateTime;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return true;
        }
    }

    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static Integer getVersionCode() {
        return new ExceptionHandler().withPenaltyLog("IBG-Core").executeAndGet(new ReturnableExecutable(){

            public Integer execute() {
                a a2 = Instabug.getApplicationContext();
                if (a2 != null) {
                    return a2.getPackageManager().getPackageInfo((String)a2.getPackageName(), (int)0).versionCode;
                }
                return -1;
            }
        }, -1);
    }

    public static boolean isProbablyAnEmulator() {
        String string2 = Build.FINGERPRINT;
        return string2.startsWith("generic") || string2.startsWith("unknown") || (string2 = Build.MODEL).contains("google_sdk") || string2.contains("Emulator") || string2.contains("Android SDK built for x86") || Build.BOARD.equals("QC_Reference_Phone") || (string2 = Build.MANUFACTURER).contains("Genymotion") || string2.contains("unknown") || Build.HOST.startsWith("Build") || Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || "google_sdk".equals(Build.PRODUCT);
    }
}

