package com.instabug.library.util.extenstions

import com.instabug.library.Constants
import com.instabug.library.core.InstabugCore

internal fun <R> Result<R>.getOrLogAndReport(
    default: R,
    message: String,
    withThrowable: Boolean = false,
    tag: String = Constants.LOG_TAG
): R = runOrLogAndReport(message, withThrowable, tag).getOrElse { default }

internal fun <R> Result<R>.runOrLogAndReport(
    message: String,
    withThrowable: Boolean = false,
    tag: String = Constants.LOG_TAG
): Result<R> = onFailure { t -> InstabugCore.reportError(t, message + t.message.orEmpty()) }
    .onFailure { t -> (message + t.message.orEmpty()).logError(t.takeIf { withThrowable }, tag) }
