package com.instabug.library.util;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Point;
import android.util.DisplayMetrics;
import android.view.Display;

import com.instabug.library.Instabug;

/**
 * Created by zak on 1/4/18.
 */

public class DisplayUtils {
    public static int getDisplayHeightInPx(Activity activity) {
        Display display = activity.getWindowManager().getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);
        return size.y;
    }

    public static int getDisplayWidthInPx(Context context) {
        return DeviceStateProvider.getDisplayMetrics(context).widthPixels;
    }

    public static int getDisplayHeightInPx(Context context) {
        return DeviceStateProvider.getDisplayMetrics(context).heightPixels;
    }

    public static int dpToPxIntRounded(Resources resources, int dp) {
        return Math.round(dpToPx(resources, dp));
    }

    public static float dpToPx(Resources resources, int dp) {
        return dp * (resources.getDisplayMetrics().xdpi / DisplayMetrics.DENSITY_DEFAULT);
    }

    public static boolean isLargeDisplay() {
        Context context = Instabug.getApplicationContext();
        if (context == null) {
            return false;
        }

        DisplayMetrics displaymetrics = DeviceStateProvider.getDisplayMetrics(context);

        int density = displaymetrics.densityDpi;

        int deviceStableDensity;
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.N) {
            deviceStableDensity = DisplayMetrics.DENSITY_DEVICE_STABLE;
        } else {
            deviceStableDensity = Math.round(displaymetrics.xdpi);
        }
        return density > deviceStableDensity;
    }

    public static boolean isSmallDevice() {
        Context context = Instabug.getApplicationContext();
        if (context == null) {
            return false;
        }
        int screenSize = context.getResources().getConfiguration().screenLayout & Configuration.SCREENLAYOUT_LONG_MASK;
        return screenSize == Configuration.SCREENLAYOUT_LONG_NO;
    }
}
