package com.instabug.library.tokenmapping

import com.instabug.library.Instabug
import com.instabug.library.firstseen.FirstSeenRequestFetcher
import com.instabug.library.networkv2.service.userattributes.AttributesSyncManager
import com.instabug.library.settings.SettingsManager

object MappedTokenChangedHandler {

    fun onMappedTokenChanged() {
        MappedTokenChangedEventBus.post(true)
        FirstSeenRequestFetcher.getInstance().fetchFirstSeenRequest(true)
        Instabug.getApplicationContext()?.let { ctx ->
            AttributesSyncManager.create(ctx).sync()
        }
    }
}