package com.instabug.library.sessionreplay.monitoring

import com.instabug.library.internal.filestore.MultiSpanSelector
import com.instabug.library.logscollection.GarbageCollector
import com.instabug.library.model.v3Session.IBGSession
import com.instabug.library.sessionV3.cache.SessionCacheManager
import com.instabug.library.sessionreplay.SR_LOG_TAG
import com.instabug.library.util.extenstions.logDWithThreadName
import com.instabug.library.util.extenstions.logVWithThreadName

class MonitoringGarbageCollector(
    private val sessionCacheManager: SessionCacheManager,
    private val dataStore: SRMonitoringSpansDataStore
) : GarbageCollector {
    override fun invoke() {
        "[Monitoring] Garbage collector running...".logDWithThreadName(SR_LOG_TAG)
        val cachedSessionsIds = sessionCacheManager.querySessions().map(IBGSession::id)
        "[Monitoring] Found sessions $cachedSessionsIds in cache".logVWithThreadName(SR_LOG_TAG)
        val spansSelector = MultiSpanSelector { directory: SRMonitoringDirectory ->
            val irrelevantDirectories = directory.oldDirectories
                .filterNot { sessionDir -> cachedSessionsIds.contains(sessionDir.sessionId) }
            "[Monitoring] Deduced irrelevant directories ${irrelevantDirectories.map { it.sessionId }}"
                .logVWithThreadName(SR_LOG_TAG)
            irrelevantDirectories
        }
        dataStore.delete(spansSelector)
    }
}