package com.instabug.library.internal.storage.cache.db.migrations

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.APMNetworkLogEntry
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.DanglingAPMNetworkLogEntry
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.INTEGER_TYPE

class Migration_43_44 : Migration {
    override fun migrate(db: SQLiteDatabase?) {
        db?.apply {
            addAPMNetworkLogExternalTraceIdColumn()
            addAPMNetworkLogExternalTraceStartTimeColumn()
            addDanglingAPMNetworkLogExternalTraceIdColumn()
            addDanglingAPMNetworkLogExternalTraceStartTimeColumn()
        }
    }

    private fun SQLiteDatabase.addAPMNetworkLogExternalTraceIdColumn() = execSQL(
        "ALTER TABLE ${APMNetworkLogEntry.TABLE_NAME} ADD COLUMN ${APMNetworkLogEntry.COLUMN_EXTERNAL_TRACE_ID} $INTEGER_TYPE DEFAULT NULL "
    )

    private fun SQLiteDatabase.addAPMNetworkLogExternalTraceStartTimeColumn() = execSQL(
        "ALTER TABLE ${APMNetworkLogEntry.TABLE_NAME} ADD COLUMN ${APMNetworkLogEntry.COLUMN_EXTERNAL_TRACE_START_TIME_MILLIS} $INTEGER_TYPE DEFAULT NULL "
    )

    private fun SQLiteDatabase.addDanglingAPMNetworkLogExternalTraceIdColumn() = execSQL(
        "ALTER TABLE ${DanglingAPMNetworkLogEntry.TABLE_NAME} ADD COLUMN ${DanglingAPMNetworkLogEntry.COLUMN_EXTERNAL_TRACE_ID} $INTEGER_TYPE DEFAULT NULL "
    )

    private fun SQLiteDatabase.addDanglingAPMNetworkLogExternalTraceStartTimeColumn() = execSQL(
        "ALTER TABLE ${DanglingAPMNetworkLogEntry.TABLE_NAME} ADD COLUMN ${DanglingAPMNetworkLogEntry.COLUMN_EXTERNAL_TRACE_START_TIME_MILLIS} $INTEGER_TYPE DEFAULT NULL "
    )
}