package com.instabug.library.diagnostics.nonfatals.networking.mapping

import com.instabug.library.diagnostics.mappers.DiagnosticsRequestParam
import com.instabug.library.diagnostics.mappers.RequestParameterResolver
import com.instabug.library.diagnostics.nonfatals.NonFatalsManager
import com.instabug.library.diagnostics.nonfatals.di.ServiceLocator
import com.instabug.library.diagnostics.nonfatals.settings.NonFatalSettings
import com.instabug.library.internal.resolver.NonFatalSettingResolver
import com.instabug.library.networkv2.request.RequestParameter
import org.json.JSONArray

class NonFatalsRequestParamResolver : RequestParameterResolver<JSONArray> {

    private val nonfatalsManager: NonFatalsManager?
        get() = ServiceLocator.getNonFatalsManager()
    private val nonFatalSettings: NonFatalSettings?
        get() = NonFatalSettingResolver.getInstance().nonFatalsSettings
    private val nonfatalsMapper: NonFatalMapper
        get() = ServiceLocator.getNonFatalMapper()

    override fun toRequestParameter(): DiagnosticsRequestParam<JSONArray> = getNonFatalsList().let {
        RequestParameter(MappingKeys.NON_FATALS_LIST, it ?: JSONArray()) to (it == null)
    }

    private fun getNonFatalsList() = nonfatalsManager
        .takeIf { nonFatalSettings?.isEnabled == true }
        ?.nonFatals
        ?.toList()
        ?.filter { nonFatal -> nonFatal.occurrences.isNotEmpty() }
        ?.takeUnless { it.isEmpty() }
        ?.let(nonfatalsMapper::toJSONArray)
}