package com.instabug.library.diagnostics.diagnostics_db.migration

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.core.InstabugCore

object DiagnosticsMigrationEngine {

    @JvmStatic
    fun onCreate(db: SQLiteDatabase?) = createDBTables(db)

    @JvmStatic
    fun onUpgrade(db: SQLiteDatabase?, oldVersion: Int) {
        db?.runCatching {
            getTargetMigration(this).migrate(oldVersion)
        }?.onFailure {
            destructiveMigration(db)
            InstabugCore.reportError(it, "Couldn't run migration on DB version $oldVersion")
        }
    }

    @JvmStatic
    fun onDowngrade(db: SQLiteDatabase?) {
        destructiveMigration(db)
    }

    private fun getTargetMigration(it: SQLiteDatabase) = DiagnosticsDBMigrationV3(it)

}